<div class="row">
    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
        <div class="site-card">
            <div class="site-card-header">
                <h3 class="title"><?php echo e(__('Profile Settings')); ?></h3>
            </div>
            <div class="site-card-body">
                <form action="<?php echo e(route('user.setting.profile-update')); ?>" method="post" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="row">
                        <div class="col-xl-3">
                            <div class="mb-3">
                                <div class="body-title"><?php echo e(__('Avatar:')); ?></div>
                                <div class="wrap-custom-file">
                                    <input
                                        type="file"
                                        name="avatar"
                                        id="avatar"
                                        accept=".gif, .jpg, .png"
                                    />


                                    <label for="avatar" <?php if($user->avatar && file_exists('assets/'.$user->avatar)): ?> class="file-ok"
                                            style="background-image: url(<?php echo e(asset($user->avatar)); ?>)" <?php endif; ?>>
                                        <img
                                            class="upload-icon"
                                            src="<?php echo e(asset('global/materials/upload.svg')); ?>"
                                            alt=""
                                        />
                                        <span><?php echo e(__('Update Avatar')); ?></span>
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="progress-steps-form">
                        <div class="row">
                            <div class="col-xl-6 col-md-12">
                                <label for="exampleFormControlInput1" class="form-label"><?php echo e(__('First Name')); ?></label>
                                <div class="input-group">
                                    <input
                                        type="text"
                                        class="form-control"
                                        name="first_name"
                                        value="<?php echo e($user->first_name); ?>"
                                        placeholder="First Name"
                                    />
                                </div>
                            </div>
                            <div class="col-xl-6 col-md-12">
                                <label for="exampleFormControlInput1" class="form-label"><?php echo e(__('Last Name')); ?></label>
                                <div class="input-group">
                                    <input
                                        type="text"
                                        class="form-control"
                                        name="last_name"
                                        value="<?php echo e($user->last_name); ?>"
                                        placeholder="Last Name"
                                    />
                                </div>
                            </div>
                            <div class="col-xl-6 col-md-12">
                                <label for="exampleFormControlInput1" class="form-label"><?php echo e(__('Username')); ?></label>
                                <div class="input-group">
                                    <input
                                        type="text"
                                        class="form-control"
                                        name="username"
                                        value="<?php echo e($user->username); ?>"
                                        placeholder="Username"
                                    />
                                </div>
                            </div>
                            <div class="col-xl-6 col-md-12">
                                <label for="exampleFormControlInput1" class="form-label"><?php echo e(__('Gender')); ?></label>
                                <div class="input-group">
                                    <select name="gender" id="kycTypeSelect" class="nice-select site-nice-select"
                                            required>
                                        <?php $__currentLoopData = ['male','female','other']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gender): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option <?php if($user->gender == $gender): ?> selected
                                                    <?php endif; ?> value="<?php echo e($gender); ?>"><?php echo e($gender); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>

                            <div class="col-xl-6 col-md-12">
                                <label for="exampleFormControlInput1"
                                       class="form-label"><?php echo e(__('Date of Birth')); ?></label>
                                <div class="input-group">
                                    <input
                                        type="date"
                                        name="date_of_birth"
                                        class="form-control"
                                        value="<?php echo e($user->date_of_birth); ?>"
                                        placeholder="Date of Birth"
                                    />
                                </div>
                            </div>

                            <div class="col-xl-6 col-md-12">
                                <label for="exampleFormControlInput1"
                                       class="form-label"><?php echo e(__('Email Address')); ?></label>
                                <div class="input-group">
                                    <input type="email" disabled class="form-control disabled"
                                           value="<?php echo e($user->email); ?>" placeholder="Email Address"
                                    />
                                </div>
                            </div>
                            <div class="col-xl-6 col-md-12">
                                <label for="exampleFormControlInput1" class="form-label"><?php echo e(__('Phone')); ?></label>
                                <div class="input-group">
                                    <input
                                        type="text"
                                        class="form-control"
                                        name="phone"
                                        value="<?php echo e($user->phone); ?>"
                                        placeholder="Phone"
                                    />
                                </div>
                            </div>
                            <div class="col-xl-6 col-md-12">
                                <label for="exampleFormControlInput1" class="form-label"><?php echo e(__('Country')); ?></label
                                >
                                <div class="input-group">
                                    <input
                                        type="text"
                                        class="form-control disabled"
                                        value="<?php echo e($user->country); ?>"
                                        placeholder="Country"
                                        disabled
                                    />
                                </div>
                            </div>

                            <div class="col-xl-6 col-md-12">
                                <label for="exampleFormControlInput1" class="form-label"><?php echo e(__('City')); ?></label>
                                <div class="input-group">
                                    <input
                                        type="text"
                                        class="form-control"
                                        name="city"
                                        value="<?php echo e($user->city); ?>"
                                        placeholder="City"
                                    />
                                </div>
                            </div>
                            <div class="col-xl-6 col-md-12">
                                <label for="exampleFormControlInput1" class="form-label"><?php echo e(__('Zip')); ?></label>
                                <div class="input-group">
                                    <input
                                        type="text"
                                        class="form-control"
                                        name="zip_code"
                                        value="<?php echo e($user->zip_code); ?>"
                                        placeholder="Zip"
                                    />
                                </div>
                            </div>
                            <div class="col-xl-6 col-md-12">
                                <label for="exampleFormControlInput1" class="form-label"><?php echo e(__('Address')); ?></label>
                                <div class="input-group">
                                    <input
                                        type="text"
                                        class="form-control"
                                        name="address"
                                        value="<?php echo e($user->address); ?>"
                                        placeholder="Address"
                                    />
                                </div>
                            </div>
                            <div class="col-xl-6 col-md-12">
                                <label for="exampleFormControlInput1"
                                       class="form-label"><?php echo e(__('Joining Date')); ?></label>
                                <div class="input-group">
                                    <input
                                        type="text"
                                        class="form-control disabled"
                                        value="<?php echo e(carbonInstance($user->created_at)->toDayDateTimeString()); ?>"
                                        placeholder="Joining Date"
                                        disabled
                                    />
                                </div>
                            </div>

                            <div class="col-xl-6 col-md-12">
                                <button type="submit" class="site-btn blue-btn"><?php echo e(__('Save Changes')); ?></button>
                            </div>
                        </div>
                    </div>
                </form>

            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/elitnkjj/public_html/resources/views/frontend/user/setting/include/__profile.blade.php ENDPATH**/ ?>