<?php $__env->startSection('title'); ?>
    <?php echo e(__('FAQ Section')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="main-content">
        <div class="page-title">
            <div class="container-fluid">
                <div class="row justify-content-center">
                    <div class="col-xl-12">
                        <div class="title-content">
                            <h2 class="title"><?php echo e(__('FAQ Section')); ?></h2>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="container-fluid">
            <div class="row justify-content-center">
                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
                    <div class="site-card">
                        <div class="site-card-header">
                            <h3 class="title"><?php echo e(__('Titles and Activity')); ?></h3>
                        </div>
                        <div class="site-card-body">
                            <form action="<?php echo e(route('admin.page.section.section.update')); ?>" method="post"
                                  enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="section_code" value="faq">
                                <div class="site-input-groups row">
                                    <label for="" class="col-sm-3 col-label pt-0"><?php echo e(__('Section Activity')); ?><i
                                            icon-name="info" data-bs-toggle="tooltip" title=""
                                            data-bs-original-title="Manage Section Visibility"></i></label>
                                    <div class="col-sm-3">
                                        <div class="site-input-groups">
                                            <div class="switch-field">
                                                <input type="radio" id="active" name="status" <?php if($status): ?> checked
                                                       <?php endif; ?> value="1"/>
                                                <label for="active"><?php echo e(__('Show')); ?></label>
                                                <input type="radio" id="deactivate" name="status" <?php if(!$status): ?> checked
                                                       <?php endif; ?> value="0"/>
                                                <label for="deactivate"><?php echo e(__('Hide')); ?></label>
                                            </div>
                                        </div>
                                    </div>
                                </div>


                                <div class="site-input-groups row">
                                    <div class="col-xl-3 col-lg-3 col-md-3 col-sm-12 col-label">
                                        <?php echo e(__('Right Image')); ?>

                                    </div>
                                    <div class="col-xl-9 col-lg-9 col-md-9 col-sm-12">
                                        <div class="wrap-custom-file">
                                            <input type="file" name="left_img" id="leftImg"
                                                   accept=".gif, .jpg, .png"/>
                                            <label for="leftImg" class="file-ok"
                                                   style="background-image: url(<?php echo e(asset($data->left_img)); ?>)">
                                                <img class="upload-icon"
                                                     src="<?php echo e(asset('global/materials/upload.svg')); ?>" alt=""/>
                                                <span><?php echo e(__('Update Image')); ?></span>
                                            </label>
                                        </div>
                                    </div>
                                </div>

                                <div class="site-input-groups row">
                                    <label for="" class="col-sm-3 col-label"><?php echo e(__('Faq Section Title Small')); ?></label>
                                    <div class="col-sm-9">
                                        <input type="text" name="title_small" class="box-input"
                                               value="<?php echo e($data->title_small); ?>">
                                    </div>
                                </div>
                                <div class="site-input-groups row">
                                    <label for="" class="col-sm-3 col-label"><?php echo e(__('Faq Section Title Big')); ?></label>
                                    <div class="col-sm-9">
                                        <input type="text" name="title_big" class="box-input"
                                               value="<?php echo e($data->title_big); ?>">
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="offset-sm-3 col-sm-9">
                                        <button type="submit"
                                                class="site-btn-sm primary-btn w-100"><?php echo e(__('Save Changes')); ?></button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>

                    <div class="site-card">
                        <div class="site-card-header">
                            <h3 class="title"><?php echo e(__('Faq Section Contents')); ?></h3>
                            <div class="card-header-links">
                                <a href="" class="card-header-link" type="button" data-bs-toggle="modal"
                                   data-bs-target="#addNew"><?php echo e(__('Add New')); ?></a>
                            </div>
                        </div>
                        <div class="site-card-body">
                            <div class="site-table table-responsive">
                                <table class="table">
                                    <thead>
                                    <tr>
                                        <th scope="col"><?php echo e(__('Title')); ?></th>
                                        <th scope="col"><?php echo e(__('Description')); ?></th>
                                        <th scope="col"><?php echo e(__('Action')); ?></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__currentLoopData = $landingContent; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $content): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td>
                                                <?php echo e($content->title); ?>

                                            </td>
                                            <td><?php echo e($content->description); ?></td>
                                            <td>
                                                <button class="round-icon-btn primary-btn editContent" type="button"
                                                        data-content="<?php echo e(json_encode($content)); ?>">
                                                    <i icon-name="edit-3"></i>
                                                </button>
                                                <button class="round-icon-btn red-btn deleteContent" type="button"
                                                        data-id="<?php echo e($content->id); ?>">
                                                    <i icon-name="trash-2"></i>
                                                </button>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>


                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal for Add New  -->
    <?php echo $__env->make('backend.page.section.include.__add_new_faq', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Modal for Add New How It Works End -->

    <!-- Modal for Edit -->
    <?php echo $__env->make('backend.page.section.include.__edit_faq', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Modal for Edit  End-->

    <!-- Modal for Delete  -->
    <?php echo $__env->make('backend.page.section.include.__delete_faq', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Modal for Delete  End-->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>
        $('.editContent').on('click',function (e) {
            "use strict";
            e.preventDefault();
            var content = $(this).data('content');

            $('#updatedId').val(content.id);

            $('.title0').val(content.title);
            $('.description').val(content.description);

            $('#editContent').modal('show');
        });

        $('.deleteContent').on('click',function (e) {
            "use strict";
            e.preventDefault();
            var id = $(this).data('id');
            $('#deleteId').val(id);
            $('#deleteContent').modal('show');
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/bankeczh/elitebittrade.com/resources/views/backend/page/section/faq.blade.php ENDPATH**/ ?>